#pragma once
#include <glut.h>
#include <gl/gl.h>
#include <gl/glu.h>
#include <algorithm>
#include <vector>

class Light
{
	public:
		Light(int id, std::vector<GLfloat> pos);	//ID (GL_LIGHTX), light position
		~Light();

		//Setters for light properties
		void SetAmbient(float r, float g, float b);
		void SetDiffuse(float r, float g, float b);
		void SetAttenuation(float constant, float linear, float quadratic);
		
		//Gets ID (GL_LIGHTX) of this light
		int GetID();

		//Getters and Setters
		bool GetIsOn();
		void SetIsOn(bool state);

		std::vector<GLfloat> GetPosition();	//Gets where the light is in the world

		//Flash flashes the light for flashDuration, turning it on and off (1 cycle) in cycleTime seconds
		void Flash(float cycleTime, float flashDuration, float dt);

		void Update(float dt);	//Update for any flashing
		virtual void Render();	//Virtual function, lights render differently based on type

		bool CurrentlyFlashing = false;	//Is the light flashing?

	protected:
		int _ID;
		std::vector<GLfloat> _Position;
		bool _IsOn = true;
		std::vector<GLfloat> Ambient = { 0.10f, 0.10f, 0.10f, 1.0f };	//
		std::vector<GLfloat> Diffuse = { 0.6f, 0.6f, 0.6f, 1.0f };	//		Defaults
		float _ConstAtten;
		float _LinearAtten;
		float _QuadraticAtten;

		std::vector<GLfloat> _PreFlashAmbient = { 0.10f, 0.10f, 0.10f, 1.0f };	//
		std::vector<GLfloat> _PreFlashDiffuse = { 0.6f, 0.6f, 0.6f, 1.0f };	//		Defaults - values of Ambient and Diffuse before we begun the flashing
		bool _ShouldFlash;	//Should we flash the light?
		float _FlashDuration;	//How long we should flash the light for
		float _DurationFlashed;	//How long we've been flashing for
		std::vector<float> _FlashDifValues;		//
		std::vector<float> _FlashAmbValues;		// Stores increment values for flashing the light, based on a calculation between Ambient/Diffuse values and cycleTime
		float _FlashAmbMax = 1.0f;		//
		float _FlashDifMax = 1.0f;		//		Maximum Ambient and Diffuse values we should reach when flashing before beginning subtraction of increment
		bool shouldAdd = false;	//Should we add or subtract the increment value for flashing?
};

